<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class MainUnit extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = [
        'name',
        'category_id'
    ];

    protected $translatable = [
        'name',
    ];
    
    
     public function category()
    {
        return $this->belongsTo(UnitCatogry::class,'category_id');
    }
}
