<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class ModelGroup extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = ['name'];
    protected $translatable = ['name'];

    public function mainModels()
    {
        return $this->belongsToMany(MainModel::class)->withPivot('type');
    }
}
