<?php

namespace App\Models;

use App\Http\Resources\NetworkResource;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Network extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'status' => 'required|boolean',
        'account_id' => 'required|exists:accounts,id,status,sub',
    ];

    protected $fillable = [
        'company_id',
        'branch_id',
        'name',
        'status',
        'account_id',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function resolveResource()
    {
        return NetworkResource::class;
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
