<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OpenBalance extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function products()
    {
        return $this->hasMany(OpenBalanceProduct::class, 'open_balances_id');
    }
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
}
