<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PaymentMethod extends Model
{
    use HasFactory, HasTranslations;

    protected $fillable = [
        'name',
        'rule',
        'model',
        'account_name',
        'resource',

    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'rule' => 'json',
    ];

    public function company()
    {
        return $this->belongsToMany(Company::class);
    }
    public function model()
    {
        return app($this->model);
    }

    public function paymentMethodTypes(){
        return $this->hasMany(PaymentMethodType::class);
    }
}
