<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductQuantityTrack extends Model
{
    use HasFactory;

    protected $fillable = [
        'quantity',
        'product_id',
        'journal_id',
        'product_unit_id',
        'product_warehouse_id',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function journal()
    {
        return $this->belongsTo(Journal::class);
    }

    public function productUnit()
    {
        return $this->belongsTo(ProductUnit::class);
    }

    public function productWarehouse()
    {
        return $this->belongsTo(ProductWarehouse::class);
    }
}
