<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Section extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    protected $table = 'careers_sections';

    const SECTION_TYPE = 2;

    const RULES = [
        'name' => 'nullable',
        'type' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'nullable|string',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'type',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
