<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceBranch extends Model
{
    use HasFactory;

    const RULES = [
        'branches.*.branch_id' => 'nullable',
        'branches.*.branch_price' => 'required_with:branches.*.branch_id',
        'branches.*.home_price' => 'nullable',
    ];

    protected $fillable = [
        'service_id',
        'branch_id',
        'branch_price',
        'home_price',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
