<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use App\Http\Enums\Setting\SettingTypeEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Setting extends Model
{
    use HasFactory, HasTranslations;

    const UPLOADED_FILES = 'uploads/settings';

    protected $fillable = [
        'label',
        'key',
        'value',
        'type',
    ];

    protected $translatable = [
        'label',
    ];

    protected $casts = [
        'type' => SettingTypeEnum::class,
    ];
}
