<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shift extends Model
{
    use HasFactory;

    protected $fillable = [
        'branch_id',
        'treasury_id',
        'employee_id',
        'start_amount',
        'end_amount',
        'open_name',
        'close_name',
        'auto_shift_id',
    ];

    public function journals()
    {
        return $this->hasMany(Journal::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function treasury()
    {
        return $this->belongsTo(Treasury::class);
    }

    public function autoShift()
    {
        return $this->belongsTo(AutoShift::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function getStartAmountAttribute($value)
    {
        return $value / 100;
    }

    public function setStartAmountAttribute($value)
    {
        $this->attributes['start_amount'] = $value * 100;
    }

    public function getEndAmountAttribute($value)
    {
        return $value / 100;
    }

    public function setEndAmountAttribute($value)
    {
        $this->attributes['end_amount'] = $value * 100;
    }
}
