<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasFactory;

    protected $fillable = [
        'tracking_code',
        'company_id',
        'sender_id',
        'receiver_id',
        'branch_id',
        'warehouse_id',
        'from',
        'to',
        'worker_id',
        'type_id',
        'payment_method_id',
        'total_tax',
        'total_discount',
        'total_cost',
        'notes',
        'status',
        'key',
        'delivery_type',
       
    ];
    public $with =   ['items', 'sender', 'receiver', 'warehouse', 'branch', 'worker', 'type', 'paymentMethod'];
    public function items()
    {
        return $this->hasMany(ShipmentItem::class, 'shipment_id', 'id');
    }
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function sender()
    {
        return $this->belongsTo(Client::class, 'sender_id');
    }
    public function receiver()
    {
        return $this->belongsTo(ShipmentReceiver::class, 'receiver_id');
    }
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
    public function worker()
    {
        return $this->belongsTo(Worker::class);
    }
    public function type()
    {
        return $this->belongsTo(ShipmentType::class, 'type_id');
    }
    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    public function rejectedShipment()
    {
        return $this->hasOne(RejectedShipment::class, 'shipment_id');
    }
}
