<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use App\Http\Enums\Subscription\PaymentStatusEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_id',
        'company_id',
        'start_date',
        'end_date',
        'status',
        'price',
        'payment_status',
        'payment_reference_id',
    ];

    protected $casts = [
        'status' => 'boolean',
        'payment_status' => PaymentStatusEnum::class,
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    public function scopeActive(Builder $query): void
    {
        $query->where('status', 1);
    }

    public function getPriceAttribute($value)
    {
        return $value / 100;
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function package()
    {
        return $this->belongsTo(Package::class);
    }
}
