<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SuppliersPaymentData extends Model
{
    use HasFactory;

    protected $table = 'suppliers_payment_data';
    protected $guarded = [];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id');
    }
    public function currency()
    {
        return $this->belongsTo(CompanyCurrency::class, 'currency_id');
    }
    public function country()
    {
        return $this->belongsTo(Location::class, 'country_id');
    }
}
