<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Worker extends Authenticatable
{
    use HasFactory, SoftDeletes, HasRoles, HasApiTokens, Notifiable;

    const RULES = [
        'image' => 'nullable|image',
        'status' => 'nullable|boolean',
        'has_shift' => 'nullable|boolean',
    ];

    const UPLOADED_FILES = 'uploads/worker';

    protected $fillable = [
        'employee_id',
        'role_id',
        'image',
        'status',
        'has_shift',
        'pos'

    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    // public function company()
    // {
    //     return $this->employee->company();
    // }

    public function company()
    {
        return $this->hasOneThrough(
            Company::class,
            Employee::class,
            'id',         // Foreign key on Employee table (company_id)
            'id',         // Foreign key on Company table (id)
            'employee_id', // Local key on Worker table (employee_id)
            'company_id'  // Local key on Employee table (company_id)
        );
    }

    public function shifts()
    {
        return $this->hasMany(Shift::class, 'employee_id', 'employee_id');
    }
    public function currentShift()
    {
        return $this->shifts()->where('close_name', null)->first();
    }

    public function autoShiftDetails()
    {
        return $this->hasMany(AutoShiftDetails::class, 'employee_id', 'employee_id');
    }
}
