<?php

namespace App\Rules;

use App\Models\Account;
use Illuminate\Contracts\Validation\Rule;

class CodeLengthForDeletion implements Rule
{


    public function __construct(protected Account $account)
    {
        $this->account = $account;

    }
    public function passes($attribute, $value)
    {
        return  !strlen($this->account->code) <= 2;
    }

    public function message()
    {
        return 'no';
        // return __('messages.cannot_delete_account_of_levelOne_or_levelTwo');
    }
}
