<?php

namespace App\Rules;

use App\Models\Account;
use Illuminate\Contracts\Validation\Rule;

class ParentCodeLength implements Rule
{

    public function passes($attribute, $value)
    {
        if ($value) {
            $parentAccount = Account::find($value);
            if ($parentAccount && strlen($parentAccount->code) < 2) {
                return false;
            }
        }
        return true;
    }

    public function message()
    {
        return __('messages.cannot_add_account_to_level_below_three');
    }
}
