<?php

namespace App\Rules;


use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\DB;

class UniqueBarcodePerCompany implements Rule
{
    private $companyId;
    private $productId;

    public function __construct($companyId, $productId = null)
    {
        $this->companyId = $companyId;
        $this->productId = $productId;
    }

    public function passes($attribute, $value)
    {
        $query = DB::table('product_unit')
            ->rightJoin('products', 'products.id', '=', 'product_unit.product_id')
            ->where('products.company_id', $this->companyId)
            ->where('product_unit.barcode', $value);

        if ($this->productId) {
            // Exclude the current product's ID from the query
            $query->where('products.id', '!=', $this->productId);
        }

        return !$query->exists(); // Return true if no duplicate exists, false otherwise
    }
    public function message()
    {
        return __('messages.bar_code_exists');
    }
}
