<?php

namespace App\Rules;

use App\Models\Delivery;
use App\Http\Helper\CompanyHelper;
use Illuminate\Contracts\Validation\Rule;

class ValidDeliveryRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
    }
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return Delivery::where('id', $value)
            ->whereHas('branch', function ($query) {
                $query->where('company_id', CompanyHelper::getCompany(request())->id);
            })
            ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Invalid delivery.';
    }
}
