<?php

namespace App\Rules;

use App\Http\Helper\CompanyHelper;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\DB;


class ValidRefIdForType implements Rule
{
    protected $type;

    public function __construct($type)
    {
        $this->type = $type;
    }

    public function passes($attribute, $value)
    {
        if ($this->type === 'client') {
            return DB::table('clients')->where('id', $value)->where('company_id', CompanyHelper::getId())->exists();
        } elseif ($this->type === 'supplier') {
            return DB::table('suppliers')->where('id', $value)->where('company_id', CompanyHelper::getId())->exists();
        }

        return false;
    }

    public function message()
    {
        return 'The selected reference ID is invalid for the provided reference type.';
    }
}
