<?php

namespace App\Rules;

use Closure;
use App\Models\Location;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidateArea implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $locationIsCountry = Location::where('id', $value)->whereNull('parent_id')->exists();

        if ($locationIsCountry) {
        
            $fail(__('messages.location_is_country_not_area'));
        }

        // $locationIsCity = Location::where('id', $value)->whereHas('children')->exists();
      

        // if ($locationIsCity) {
        
        //     $fail(__('messages.location_is_city_not_area'));
        // }
    }
}
