<?php

namespace App\Trait;

use App\Models\Branch;
use App\Models\Warehouse;
use App\Http\Enums\Bound\BoundTypeEnum;
use App\Http\Services\Account\JournalService;
use App\Http\Services\Account\AccountService;
use App\Http\Helper\AccountHelper;
use App\Models\Account;

trait BoundHelperTrait
{
    private function createJournal(
        ?Branch $branch = null,
        ?Warehouse $warehouse = null,
        ?array $boundEntries = [],
        $type,
        $status
    ) {
        $sides = $this->getJournalSides($boundEntries);
// dd($sides);
        JournalService::createJournal(
            date: now(),
            type: $type == 'receivables' ? __('constants.journal_receipt_voucher_type') : __('constants.journal_payment_voucher_type'),
            source: 'Bounds',
            description: $this->bound->description,
            file: null,
            employee: null,
            status: $status,
            debit: $sides['debit'],
            credit: $sides['credit'],
            journalable: $this->bound,
            branch: $branch ?? null,
            warehouse: $warehouse ?? null,
        );
    }

    private function getJournalSides($boundEntries): array
    {

        // route payments type sides.
        if (request()->route()->type == strtolower(BoundTypeEnum::PAYMENTS->name)) {
            return $this->paymentTypeEntries($boundEntries);
        }

        // route receivables type sides.
        return $this->receivableTypeEntries($boundEntries);
    }

    private function paymentTypeEntries($boundEntries): array
    {
        
$sideDiscount=(float) ($this->discount ?? 0.0);

        $entries = [];
      if (!empty($this->discount)) {
            $entries['credit'][] = [
                'account'    => AccountService::getAccountForModel(AccountHelper::ACCOUNT_EARNED_DISCOUNT, 'Purchases'),
                'type'       => [
                    'type' => null,
                    'id'   => null,
                ],
                'amount'     => $sideDiscount,
               
                'entry_type' => "credit",
            ];
        }
        $entries['credit'][] =
            [
                'account' => $this->bound->payment->account,
                'type' => [
                    'type' => $this->bound->payment_type,
                    'id' => $this->bound->payment_id,
                ],
                'amount' => $this->bound->value,
                'entry_type' => "credit",
            ];

        foreach ($boundEntries as $boundEntry) {
            $account =  $boundEntry->entry instanceof Account ?  $boundEntry->entry : $boundEntry->entry->account();
            $entries['debit'][] =
                [
                    'account' => $account,
                    'type' => [
                        'type' => $boundEntry->entry_type,
                        'id' => $boundEntry->entry_id,
                    ],
                    'amount' => $boundEntry->value + $sideDiscount,
                    'entry_type' => "debit",
                ];
        }

        return $entries;
    }

    private function receivableTypeEntries($boundEntries): array
    {
        $sideDiscount=(float) ($this->discount ?? 0.0);
        // dd($this->discount);
        $entries = [];
     if (!empty($this->discount)) {
            $entries['debit'][] = [
                'account'    => AccountService::getAccountForModel(AccountHelper::ACCOUNT_ALLOWED_DISCOUNT, 'sales'),
                'type'       => [
                    'type' => null,
                    'id'   => null,
                ],
                'amount'     => $sideDiscount, // the discount amount from the request
                'entry_type' => "debit",
            ];
        }
        foreach ($boundEntries as $boundEntry) {
            $account =  $boundEntry->entry instanceof Account ?  $boundEntry->entry : $boundEntry->entry->account();
            $entries['credit'][] =
                [
                    'account' => $account,
                    'type' => [
                        'type' => $boundEntry->entry_type,
                        'id' => $boundEntry->entry_id,
                    ],
                    'amount' => $boundEntry->value + $sideDiscount,
                    'entry_type' => "credit",
                ];
        }
        $entries['debit'][] =
            [
                'account' => $this->bound->payment->account,
                'type' => [
                    'type' => $this->bound->payment_type,
                    'id' => $this->bound->payment_id,
                ],
                'amount' => $this->bound->value  ,
                'entry_type' => "debit",
            ];

        return $entries;
    }
}
