<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Address;
use App\Models\Attribute;
use App\Models\Company;
use App\Models\Country;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Client>
 */
class ClientFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $id = Attribute::create([
            'name' => [
                'ar' => $this->faker->name(),
                'en' => $this->faker->name(),
            ],
            'type' => 'title',
            'company_id' => function()
            {
                return Company::inRandomOrder()->first()->id;
            },
        ])->id;
        dd($id);
        return [
            'company_id' => rand(100, 111),
            'code' => $this->faker->unique()->numberBetween(1111, 9999999),
            'membership_number' => $this->faker->numberBetween(1111, 9999999),
            'title_id' => $id,
            'group_id' => function()
            {
                return Attribute::create([
                    'name' => [
                        'ar' => $this->faker->name(),
                        'en' => $this->faker->name(),
                    ],
                    'type' => 'group',
                    'company_id' => function()
                    {
                        return Company::inRandomOrder()->first()->id;
                    },
                ])->id;
            },
            'name' => $this->faker->name,
            'image' => $this->faker->optional()->imageUrl(),
            'phone' => $this->faker->phoneNumber,
            'email' => $this->faker->optional()->email(),
            'id_number' => $this->faker->optional()->numberBetween(1111, 9999999),
            'address_id' => function () {
                return Address::create([
                    'address_line' => $this->faker->sentence(),
                    'post_code' => $this->faker->numberBetween(1111, 9999),
                    'area_id'=> function()
                    {
                        return Country::whereNotNull('city_id')->inRandomOrder()->first()->id;
                    },
                ]);
            },
            'birth_date' => $this->faker->optional()->date,
            'work_phone' => $this->faker->optional()->phoneNumber,
            'gender' => $this->faker->randomElement(['male', 'female']),
            'job_name' => $this->faker->word,
            'favorite_employee_id' => $this->faker->optional()->numberBetween(100, 110),
            'crn' => $this->faker->optional()->numberBetween(1111, 9999999),
            'trn' => $this->faker->optional()->numberBetween(1111, 9999999),
            'note' => $this->faker->optional()->sentence,
            'status' => $this->faker->optional()->boolean,
            'id_client' => $this->faker->optional()->boolean,
            'cache' => $this->faker->optional()->boolean,
            'internet' => $this->faker->optional()->boolean,
            'fingerprint' => $this->faker->optional()->boolean,

        ];
    }
}
