<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Service>
 */
class ServiceFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $categoryIds = Category::where('type', 'services_category')->pluck('id')->toArray();

        return [
            'code' =>  rand(200, 20000),
            'category_id' => function () use ($categoryIds) {
                return $this->faker->randomElement($categoryIds);
            },
            'name' => [
                'en' => $this->faker->name(),
                'ar' => $this->faker->name()
            ],
            'description' => [
                'en' => $this->faker->paragraph(),
                'ar' => $this->faker->paragraph()
            ],
            'status' => $this->faker->boolean(),
            'fast' => $this->faker->boolean(),
        ];
    }
}
