<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => [
                'ar' => $this->faker->name(),
                'en' => $this->faker->name(),
            ],
            'email' => $this->faker->unique()->safeEmail(),
            'email_verified_at' => now(),
            'password' => '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', // password
            'remember_token' => Str::random(10),
            'role' => rand(0, 1),
            'phone' => $this->faker->phoneNumber(),
            'birth_date' => $this->faker->dateTime(),
            'id_type' => rand(0, 1),
            'id_no' => $this->faker->randomNumber(),
            'attend_method_id' => rand(1, 10),
            'hired_at' => $this->faker->dateTime(),
            'status' => rand(0, 1),
            'online_booking' => rand(0, 1),
            'appear_in_calendar' => rand(0, 1),
            'has_imprint' => rand(0, 1),
            'job_id' => rand(1, 20),
            'address_id' => rand(1, 20),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}
