<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->json('name');
            $table->foreignId('company_id')->constrained()->cascadeOnDelete();
            $table->foreignId('address_id')->nullable()->references('id')->on('addresses')->cascadeOnDelete();
            $table->foreignId('group_settings_id')->nullable()->constrained()->nullOnDelete();
            $table->string('phone_1')->nullable();
            $table->string('phone_2')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->string('manager_fname')->nullable();
            $table->string('manager_lname')->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->integer('home_service')->default(0)->nullable();
            $table->integer('beauty_expert')->default(0)->nullable();
            $table->integer('delivers')->default(0)->nullable();
            $table->integer('number_of_employees')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};
