<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();

            $table->foreignId('company_id')->constrained()->cascadeOnDelete();
            $table->text('code')->unique();
            $table->string('membership_number')->nullable();
            $table->foreignId('title_id')->nullable()->references('id')->on('attributes')->nullOnDelete();
            $table->foreignId('group_id')->nullable()->references('id')->on('attributes')->nullOnDelete();
            $table->string('name');
            $table->string('image')->nullable();
            $table->string('phone');
            $table->string('email')->unique()->nullable();
            $table->string('id_number')->nullable();
            $table->foreignId('address_id')->nullable()->references('id')->on('addresses');
            $table->date('birth_date')->nullable();
            $table->string('work_phone')->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->string('job_name')->nullable();
            $table->foreignId('favorite_employee_id')->nullable()->references('id')->on('users')->nullOnDelete();
            $table->string('crn')->nullable(); // Commercial Registration number
            $table->string('trn')->nullable(); // Tax registration number
            $table->text('note')->nullable();
            // $table->boolean('status')->nullable();
            $table->boolean('is_client')->nullable();
            $table->boolean('cache')->nullable();
            $table->boolean('internet')->nullable();
            $table->boolean('fingerprint')->nullable();

            // Add a unique constraint for company_id and phone
            $table->unique(['company_id', 'phone']);

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
