<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained();
            $table->json('name');
            $table->text('code');
            $table->string('phone');
            $table->string('email');
            $table->date('birth_date');
            $table->tinyInteger('identity_type');
            $table->text('ID_number');
            $table->date('hiring_date');
            $table->boolean('status');
            $table->boolean('online');
            $table->boolean('calendar_appearance');
            $table->foreignId('attendance_method_id')->constrained()->nullable();
            $table->foreignId('section_id')->constrained('careers_sections')->nullable();
            $table->foreignId('career_id')->constrained('careers_sections')->nullable();
            $table->foreignId('address_id')->constrained();
            $table->foreignId('branch_id')->constrained();
            $table->string('password');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
