<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillSellNaturesTable extends Migration
{
    protected $fillable = [
        'bill_id',
        'main_sell_nature_id',
        'selling_type',
        'selling_id',
        'resource',
        'value',
    ];

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bill_sell_natures', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bill_id')->constrained();
            $table->foreignId('main_sell_nature_id')->constrained();
            $table->nullableMorphs('selling');
            $table->string('model')->nullable();
            $table->string('resource')->nullable();
            $table->json('value');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bill_sell_natures');
    }
}
