<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBoundsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bounds', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained();
            $table->tinyInteger('type');
            $table->dateTime('date');
            $table->text('description');
            $table->morphs('entry'); // like Client - Supplier
            $table->string('file')->nullable();
            $table->string('ref_number')->nullable();
            $table->string('tax_number')->nullable();
            $table->morphs('payment');
            $table->string('resource');
            $table->foreignId('payment_method_id')->constrained();
            $table->unsignedBigInteger('value');
            // $table->foreignId('tax_id')->constrained();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bounds');
    }
}
