<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('warehouse_units', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_warehouse_id')->constrained('product_warehouses')->cascadeOnDelete();
            $table->foreignId('unit_id')->nullable()->constrained('company_units')->cascadeOnDelete();
            $table->bigInteger('purchasing_price');
            $table->bigInteger('selling_price');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('warehouse_units');
    }
};
