<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

 return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        DB::unprepared("
            CREATE TRIGGER before_insert_model_has_permissions
            BEFORE INSERT ON model_has_permissions
            FOR EACH ROW
            BEGIN
                SET NEW.created_at = NOW();
                SET NEW.updated_at = NOW();
            END;
        ");

        DB::unprepared("
            CREATE TRIGGER before_update_model_has_permissions
            BEFORE UPDATE ON model_has_permissions
            FOR EACH ROW
            BEGIN
                SET NEW.updated_at = NOW();
            END;
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('DROP TRIGGER IF EXISTS before_insert_model_has_permissions;');
        DB::unprepared('DROP TRIGGER IF EXISTS before_update_model_has_permissions;');

        DB::statement("
            ALTER TABLE model_has_permissions
            DROP COLUMN created_at,
            DROP COLUMN updated_at;
        ");
    }
};
