<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_revenues', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained();
            $table->integer('code');
            $table->enum('type', ['sales', 'rent']);
            $table->date('date');
            $table->string('client_name');
            $table->string('phone');
            $table->string('city');
            $table->decimal('delivery', 8, 2, true)->default(0);
            $table->decimal('network', 8, 2, true)->default(0);
            $table->decimal('cash', 8, 2, true)->default(0);
            $table->decimal('transfer', 8, 2, true)->default(0);
            $table->decimal('electronic', 8, 2, true)->default(0);
            $table->decimal('wallet', 8, 2, true)->default(0);
            $table->decimal('tap', 8, 2, true)->default(0);
            $table->decimal('stc', 8, 2, true)->default(0);
            $table->decimal('mada', 8, 2, true)->default(0);
            $table->decimal('delivery_cost', 8, 2, true)->default(0);
            $table->decimal('total_without_taxes', 8, 2, true);
            $table->decimal('tax', 8, 2, true)->default(0);
            $table->decimal('total', 8, 2, true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_revenues');
    }
};
