<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class AccountPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            ['name' => 'view accounts', 'name_ar' => 'عرض الحسابات'],
            ['name' => 'create accounts', 'name_ar' => 'إنشاء حسابات'],
            ['name' => 'edit accounts', 'name_ar' => 'تعديل الحسابات'],
            ['name' => 'delete accounts', 'name_ar' => 'حذف الحسابات'],
        ];

        $guards = ['company', 'worker'];

        foreach ($guards as $guard) {
            foreach ($permissions as $permission) {
                Permission::firstOrCreate([
                    'name' => $permission['name'],
                    'name_ar' => $permission['name_ar'],
                    'guard_name' => $guard
                ]);
            }
        }
    }
}
