<?php

namespace Database\Seeders;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AttendanceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'view',
            'show',
            'store',
            'departure',
            'edit',
            'destroy',
            'employees',
        ];

        $models = [
            'attendances' => 'الحضور',
        ];

        $guards = [
            'worker',
            'company',
        ];

        $permissionTranslations = [
            'view' => 'عرض',
            'show' => 'إظهار',
            'store' => 'إنشاء',
            'departure' => 'انصراف',
            'edit' => 'تعديل',
            'destroy' => 'حذف',
            'employees' => 'للوظفين',
        ];

        foreach ($models as $model => $model_ar) {
            foreach ($guards as $guard) {
                foreach ($permissions as $permission) {
                    $permission_ar = $permissionTranslations[$permission] ?? $permission;
                    Permission::firstOrCreate([
                        'guard_name' => $guard,
                        'name' => "$permission $model",
                        'name_ar' => "$permission_ar $model_ar",
                    ]);
                }
            }
        }
    }
}
