<?php

namespace Database\Seeders;

use App\Models\MainCurrency;
use Illuminate\Database\Seeder;

class MainCurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $currencies = [
            [
                'ar' => 'يورو',
                'en' => 'EUR',
            ],
            [
                'ar' => 'دولار',
                'en' => 'USD',
            ],
            [
                'ar' => 'جنيه مصري',
                'en' => 'EGP',
            ],
            [
                'ar' => 'ريال سعودي',
                'en' => 'SR',
            ],
        ];

        foreach($currencies as $currency)
        {
            MainCurrency::create([
                'name' => $currency,
                'code' => $currency,
            ]);
        }
    }
}
