<?php

namespace Database\Seeders;

use App\Models\MainSellNature;
use Illuminate\Database\Seeder;

class MainSellNatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $selling_natures = [
            [
                'name' => [
                    'ar' => 'تيك اوي',
                    'en' => 'take away',
                ],
                'rule' => null,
                'resource' => null

            ],
            [
                'name' => [
                    'ar' => 'صالة البيع',
                    'en' => 'Sales hall',
                ],
                'rule' => [
                    'bill_sell_nature.table_number' => ['required', 'numeric', 'min:1']
                ],
                'resource' => null

            ],
            [
                'name' => [
                    'ar' => 'توصيل',
                    'en' => 'delivery',
                ],
                'rule' => [
                    'bill_sell_nature.type' => ['required', 'in:inner,outer'],
                    'bill_sell_nature.name' => ['required_if:bill_sell_nature.type,outer', 'string'],
                    'bill_sell_nature.id' => ['required_if:bill_sell_nature.type,inner', 'exists:deliveries,id'],
                    'bill_sell_nature.phone' => ['required', 'string'],
                ],
                'resource' => 'App\Http\Resources\SellNatureResource',
                'model' => 'App\\Models\\Delivery',
            ],
        ];

        foreach ($selling_natures as $selling_nature) {
            MainSellNature::create($selling_nature);
        }
    }
}
