<?php

namespace Database\Seeders;

use App\Models\ModelGroup;
use Illuminate\Database\Seeder;

class ModelGroupSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $groups = [
            [
                'name' => [
                    'ar' => 'مبيعات',
                    'en' => 'Sales',
                ],
            ],
            [
                'name' => [
                    'ar' => 'خدمات',
                    'en' => 'Services',
                ],
            ],
            [
                'name' => [
                    'ar' => 'مشتريات',
                    'en' => 'Purchases',
                ],
            ],
            [
                'name' => [
                    'ar' => 'مردود مبيعات',
                    'en' => 'Sales Returns',
                ],
            ],
            [
                'name' => [
                    'ar' => 'مردود مشتريات',
                    'en' => 'Purchases Returns',
                ],
            ],
            [
                'name' => [
                    'ar' => 'تعديل مخزون',
                    'en' => 'Inventory Adjustment',
                ],
            ],
            [
                'name' => [
                    'ar' => 'تحويل',
                    'en' => 'Transfer',
                ],
            ],
            [
                'name' => [
                    'ar' => 'اتلاف',
                    'en' => 'Damage',
                ],
            ],
            [
                'name' => [
                    'ar' => 'تحويل رصيد لخزنة',
                    'en' => 'Transfer Balance to Safe',
                ],
            ],
        ];

        foreach ($groups as $group) {
            ModelGroup::create($group);
        }
    }
}
