<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Support\Facades\DB;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {


        DB::table('permissions')->truncate();
        $permissions = [
            'view',
            'show',
            'create',
            'edit',
            'delete',
            'print',
            'draft',
            'isAccredited',
        ];

        $models = [
            "Warehouses" => [
                'products' => 'المنتجات',
                'services' => 'الخدمات',
                'open balance' => 'الرصيد الافتتاحي',
                'product warehouse' => 'مستودع المنتجات',
                'warehouses' => 'المستودعات',
                'stock transfer' => 'تحويل المخزون',
                'categories' => 'الفئات',
            ],
            "Setting" => [
                'roles' => 'الأدوار',
                'bounds' => 'الحدود',
                'delivers' => 'التسليمات',
                'attributes' => 'الخصائص',
                'currencies' => 'العملات',
                'payment methods' => 'طرق الدفع',
                'taxes' => 'الضرائب',
                'banks' => 'البنوك',
                'networks' => 'الشبكات',
                'treasuries' => 'الخزائن',
                'units' => 'الوحدات',
                'sections' => 'الأقسام',
                'sell natures' => 'طبيعة البيع',
            ],
            "Human_resources" => [
                'absences' => 'الغيابات',
                'dismissal notices' => 'إشعارات الفصل',
                'vacations' => 'الإجازات',
                'vacation requests' => 'طلبات الإجازة',
                'workers' => 'العمال',
                'employee transactions' => 'معاملات الموظفين',
                'employees' => 'الموظفين',
                'block reasons' => 'أسباب الحظر',
                'attendance methods' => 'طرق الحضور',
                'careers' => 'المهن',
            ],
            "Suppliers" => [
                'block suppliers' => 'حظر الموردين',
                'suppliers' => 'الموردين',
            ],
            "Bill_Sales" => [
                'fast bill sales' => 'فاتورة بيع سريع',
                'sales bills' => 'فواتير المبيعات',
                'Sales Orders' => 'طلبات البيع',
                'Sales setting' => 'إعدادات المبيعات',
                'Sales expenses' => 'النفقات',
            ],
            "Bill_Purchases" => [
                'purchase bills' => 'فواتير الشراء',
                'purchase Orders' => 'طلبات الشراء',
                'purchase setting' => 'إعدادات المشتريات',
                'purchase expenses' => 'النفقات',
            ],
            "Branches" => [
                'branches' => 'الفروع',
            ],
            "Clients" => [
                'block clients' => 'حظر العملاء',
                'clients' => 'العملاء',
            ],
            "Accounts" => [
                'journals' => 'القيود',
                'accounts' => 'الحسابات',
                // 'main accounts' => 'الحسابات الرئيسية',
                'receivables' => 'المقبوضات',
                'payments' => 'المدفوعات',
                'accounts setting' => 'إعدادات الحسابات',
            ],
        ];

        $guards = [
            'worker',
            'company',
        ];

        foreach ($models as $model => $model_items) {
            foreach ($model_items as $key => $value) {
                foreach ($guards as $guard) {
                    foreach ($permissions as $permission) {
                        $permission_ar = match ($permission) {
                            'view' => 'عرض',
                            'show' => 'إظهار',
                            'create' => 'إنشاء',
                            'edit' => 'تعديل',
                            'delete' => 'حذف',
                        'print' =>'طباعة',
                        'draft' =>'مسودة', 
                        'isAccredited' =>'اعتماد',
                        default => '',
                    };
                    Permission::firstOrCreate([
                        'guard_name' => $guard,
                        'name' => "$permission $key",  
                        'name_ar' => "$permission_ar $value",
                        'type' => $model, // Set the key to the model name
                    ]);
                }
            }
        }
        
       $reports = [
    'teacher report' => 'تقرير الاستاذ',
    'journals book' => 'دفتر قيود',
    'trial balance' => 'ميزان المراجعة',
    'account statement' => 'كشف حساب',
    'Income statement' => 'قائمة الدخل',
    'financial center' => 'المركز المالي',
    'sales report' => 'تقرير المبيعات',
];

// Reports
foreach ($guards as $guard) {
    foreach ($reports as $key => $value) {
        Permission::firstOrCreate([
            'guard_name' => $guard,
            'name' =>"view " . $key, // Set name to the key
            'name_ar' =>"عرض " . $value, // Set name to the key
            'type' => 'Reports', // Example key for reports
        ]);
    }
}
    }
}
}
