<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
class RevenuesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'view',
            'create',
        ];

        $models = [
            'company revenues' => 'إيرادات الشركة',
            'merchant revenues' => 'إيرادات التاجر',
        ];

        $guards = [
            'worker',
            'company',
        ];

        $permissionTranslations = [
            'view' => 'عرض',
            'create' => 'إنشاء',
        ];

        foreach ($models as $model => $model_ar) {
            foreach ($guards as $guard) {
                foreach ($permissions as $permission) {
                    $permission_ar = $permissionTranslations[$permission] ?? $permission;
                    Permission::create([
                        'guard_name' => $guard,
                        'name' => "$permission $model",
                        'name_ar' => "$permission_ar $model_ar",
                    ]);
                }
            }
        }
    }
}
