<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;
use App\Http\Enums\Setting\SettingTypeEnum;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $values = [
            [
                'label' => [
                    'ar' => 'app name',
                    'en' => 'app name',
                ],
                'key' => 'APP_NAME',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'insta',
                    'en' => 'insta',
                ],
                'key' => 'INSTA',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'whatsapp',
                    'en' => 'whatsapp',
                ],
                'key' => 'WHATSAPP',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'youtube',
                    'en' => 'youtube',
                ],
                'key' => 'YOUTUBE',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'x',
                    'en' => 'x',
                ],
                'key' => 'X',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'facebook',
                    'en' => 'facebook',
                ],
                'key' => 'FACEBOOK',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'phone',
                    'en' => 'phone',
                ],
                'key' => 'PHONE',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'email',
                    'en' => 'email',
                ],
                'key' => 'EMAIL',
                'value' => '/',
                'type' => SettingTypeEnum::STRING,
            ],
            [
                'label' => [
                    'ar' => 'لوجو',
                    'en' => 'logo',
                ],
                'key' => 'LOGO',
                'value' => '/',
                'type' => SettingTypeEnum::FILE,
            ],
        ];

        foreach ($values as $value) {
            Setting::create($value);
        }
    }
}
