<?php

namespace Database\Seeders;

use App\Models\Step;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class StepsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $en_names = [
            'Accounts Tree',
            'Accounts Settings',
            'Units',
            'Currency',
            'Payment Methods',
            'Sell Natures',
            'Taxes',
            'Shipment Companies',
            'Add Branch',
            'Add Products Category Service',
            'Add Employee',
            'Add Roles',
            'Add Workers',

        ];
        $ar_names = [
            'شجرة الحسابات',
            'إعدادات الحساب',
            'الوحدات',
            'العملة',
            'طرق الدفع',
            'طبيعة البيع',
            'الضرائب',
            'شركات الشحن',
            'إضافة فرع',
            'إضافة فئة منتجات خدمة',
            'إضافة موظف',
            'إضافة أدوار',
            'إضافة عمال',
        ];

        foreach ($en_names as $key => $step) {
            Step::create(
                [
                    'name' => [
                        'ar' => $ar_names[$key],
                        'en' => $en_names[$key],
                    ],
                    'number' => $key + 1,
                    'status' => true

                ]
            );
        }
    }
}
