<?php

namespace Database\Seeders;

use App\Models\Company;
use Illuminate\Database\Seeder;
use App\Models\SystemSettingsGroup;
use App\Models\SystemSetting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
class SystemSettingsSeeder extends Seeder
{
    public function run()
    {

        // remove all date in tables and added again
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Truncate tables to start fresh
        DB::table('company_system_settings')->truncate();
        DB::table('system_settings')->truncate();
        DB::table('system_settings_groups')->truncate();


        // Define settings data with Arabic names for settings and English for groups/sub-groups
        $data = [
            'Inventory Settings' => [
                'settings' => [
                    'Enable Products' => [
                        'sub_groups' => ['Products'],
                        'translation' => 'تفعيل المنتجات'
                    ],
                    'Enable Services' => [
                        'sub_groups' => ['Services'],
                        'translation' => 'تفعيل الخدمات'
                    ]
                ]
            ],
            'Purchasing Settings' => [
                'settings' => [
                    'Show Username in Purchase Invoices' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'ظهور اسم المستخدم في فواتير الشراء'
                    ],
                    'Specify Buyer or Service Recipient for Each Item in Invoice' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'تحديد اسم المشترى او مستلم الخدمة لكل صنف بالفاتورة'
                    ],
                    'Specify Time of Purchase or Service Receipt for Each Item in Invoice' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'تحديد وقت (الشراء او استلام الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Specify Date of Purchase or Service Receipt for Each Item in Invoice' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'تحديد تاريخ (الشراء او استلام الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Increase Quantity of Product or Service when Repeated in Invoices' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'زيادة (كمية / عدد) المنتج او الخدمة عند تكرار طلبه في الفواتير'
                    ],
                    'Show Supplier’s Bank Information in Invoices' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'ظهور زر تفعيل إظهار البيانات البنكية للمورد في الفواتير'
                    ],
                    'Show Product Category in Invoices and Orders' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'ظهور تصنيف المنتج في الفواتير والطلبات'
                    ],
                    'Show Product Category in Invoices and Orders' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'ظهور تصنيف المنتج في الفواتير والطلبات'
                    ],
                    'Show Discount Column at Item Level' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'اظهار عامود الخصم على مستوى الصنف'
                    ],
                    'Show Unit Column at Item Level' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'اظهار عامود الوحدة على مستوى الصنف'
                    ],
                    'Show Tax Percentage Column at Item Level' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'اظهار عامود نسبة الضريبة على مستوى الصنف'
                    ],
                    'Show Tax Inclusive Column at Item Level' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'اظهار عامود شامل الضريبة على مستوى الصنف'
                    ],
                    'enable header at Item Level' => [
                       'sub_groups' => ['Purchase Invoices','Purchase orders'],
                       'type' =>"printing",
                       'content' =>"ظهار العنوان علي مستوي الصنف",
                        'translation' => 'اظهار العنوان علي مستوي الصنف'
                    ],
                    'enable footer at Item Level' => [
                       'sub_groups' => ['Purchase Invoices','Purchase orders'],
                       'type' =>"printing",
                       'content' =>"ظهار النهاية علي مستوي الصنف",
                        'translation' => 'اظهار النهاية علي مستوي الصنف '
                    ],
                    'enable or disabled total before tax at Item Level' => [
                       'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => '  تفعيل او عدم تفعيل اظهار عامود الاجمالى قبل الضريبة علي مستوي الصنف '
                    ],
                    'enable  total tax appearance in bills at Item Level' => [
                        'sub_groups' => ['Purchase Invoices','Purchase orders'],
                        'translation' => 'امكانية تفعيل او اظهار عامود اجمالى شامل الضريبة فى مدخلات الفاتورة'
                    ],
                    'enable  total tax appearance in printing at Item Level' => [
                        'sub_groups' => ['Printing'],
                        'translation' => 'امكانية تفعيل او اظهار عامود اجمالى شامل الضريبة فى الطباعة'
                    ],
                ]
            ],
            'Sales Settings' => [
                'settings' => [
                    'Provide In-Branch Services' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تقديم الخدمات بالفرع'
                    ],
                    'Provide External Services' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تقديم خدمات خارجية'
                    ],
                    'Show Username in Sales Invoices' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'ظهور اسم المستخدم في فواتير البيع'
                    ],
                    'Specify Seller or Service Provider for Each Item in Invoice' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تحديد اسم البائع او مقدم الخدمة لكل صنف بالفاتورة'
                    ],
                    'Specify Time of Sale or Service Delivery for Each Item in Invoice' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تحديد وقت (البيع او تقديم الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Specify Date of Sale or Service Delivery for Each Item in Invoice' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تحديد تاريخ (البيع او تقديم الخدمة) لكل صنف بالفاتورة'
                    ],
                    'Increase Quantity of Product or Service when Repeated in Invoices' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'زيادة (كمية / عدد) المنتج او الخدمة عند تكرار طلبه في الفواتير'
                    ],
                    'Show Product Category in Invoices and Orders' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'ظهور تصنيف المنتج في الفواتير والطلبات'
                    ],
                    'Show Customer’s Bank Information in Invoices' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'ظهور زر تفعيل إظهار البيانات البنكية للعميل في الفواتير'
                    ],
                    'Show Discount Column at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'اظهار عامود الخصم على مستوى الصنف'
                    ],
                    'Show Unit Column at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'اظهار عامود الوحدة على مستوى الصنف'
                    ],
                    'Show Tax Percentage Column at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'اظهار عامود نسبة الضريبة على مستوى الصنف'
                    ],
                    'Show Tax Inclusive Column at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'اظهار عامود شامل الضريبة على مستوى الصنف'
                    ],
                    'enable header at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'type' =>"printing",
                        'content' =>"ظهار العنوان علي مستوي الصنف",
                        'translation' => 'اظهار العنوان علي مستوي الصنف '
                    ],
                    'enable footer at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'type' =>"printing",
                        'content' =>"ظهار النهاية علي مستوي الصنف",
                        'translation' => 'اظهار النهاية علي مستوي الصنف '
                    ],
                    'enable or disabled total before tax at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تفعيل او عدم تفعيل اظهار عامود الاجمالى قبل الضريبة علي مستوي الصنف '
                    ],
                    'enable  total tax appearance in bills at Item Level' => [
                        'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'امكانية تفعيل او اظهار عامود اجمالى شامل الضريبة فى مدخلات الفاتورة'
                    ],
                    'enable change price at quick sales' => [
                      'sub_groups' => ['Sales orders', 'Sales Invoices', 'Quick Sales'],
                        'translation' => 'تفعيل امكانية تغيير السعر من الفاتورة علي مستوي الصنف '
                    ],
                    'enable product image appearance at quick sales' => [
                        'sub_groups' => ['Quick Sales'],
                        'translation' => 'تفعيل ظهور صورة للمنتج من عدمة فى البيع السريع'
                    ],
                    'enable service image appearance at quick sales' => [
                        'sub_groups' => ['Quick Sales'],
                        'translation' => 'تفعيل ظهور صورة للخدمة من عدمة فى البيع السريع'
                    ],
                    'enable  total tax appearance in printing at Item Level' => [
                        'sub_groups' => ['Printing'],
                        'translation' => 'امكانية تفعيل او اظهار عامود اجمالى شامل الضريبة فى الطباعة'
                    ],

                ]
            ]
        ];


        foreach (Company::all() as $company) { // Retrieve all companies
            foreach ($data as $groupName => $groupData) {
                $group = SystemSettingsGroup::firstOrCreate(['name' => $groupName]);

                foreach ($groupData['settings'] as $settingName => $settingData) {
                    $setting = SystemSetting::firstOrCreate([
                        'key' => STR::slug($settingName, '_'),
                        'name' => [
                            'en' => $settingName,
                            'ar' => $settingData['translation']
                        ],
                    ]);

                    foreach ($settingData['sub_groups'] as $subGroup) {
                        DB::table('company_system_settings')->insert([
                            'company_id' => $company->id, // Insert the company_id for each setting
                            'system_settings_group_id' => $group->id,
                            'system_setting_id' => $setting->id,
                            'sub_group' => $subGroup,
                            'value' => false,
                            'content' => $settingData['content'] ?? null,
                            'type' => $settingData['type'] ?? null,
                        ]);
                    }
                }
            }
        }
    }
}
