@php
    use App\Models\Setting;
    $setting = Setting::get();
@endphp
<!DOCTYPE html>
<html lang="ar">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }

        .container {
            max-width: 600px;
            margin: 50px auto;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #1d6bb6;
            color: rgb(255, 255, 255);
            text-align: center;
            padding: 10px 0;
        }

        .logo {
            margin: 10px auto;
            display: block;
            height: 100px;
            border-radius: 30px;
        }

        .text1,
        .text {
            text-align: center;
            margin: 0;
            padding: 10px;
            color: #000000;
        }

        .verification-code {
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            color: #000000;
            margin: 0 auto;
            /* display: inline-block; */
            border-radius: 5px;
        }

        .code {
            display: inline-block;
            text-align: center;
            border: 2px solid #1d6bb6;
            padding: 5px 10px;
            border-radius: 5px;
        }

        .footer {
            background-color: #6797c5;
            color: #fff;
            text-align: center;
            padding: 20px 0;
        }

        .icon-div {
            display: inline-block;
            margin-top: 10px;
        }

        .icon-span {
            display: inline-block;
            margin: 0 5px;
        }

        .icon-logo {
            height: 25px;
            width: 25px;
            border-radius: 50%;
        }

        .font-normal {
            font-size: 12px;
            color: #fff;
        }

        .font-black {
            color: black !important;
        }

        .span-center {
            display: block;
            text-align: center
        }
    </style>

</head>

<body>
    <div class="container">
        <div class="header">
            <img src="{{ asset('public/' . Setting::UPLOADED_FILES . '/' . $setting->where('key', 'LOGO')->value('value')) }}"
                class="logo" />
            <div>

                <h2 style="color:#fff">{{ $title }}</h2>
            </div>
        </div>

        <p class="text1">
            {{ $body }}
        </p>



        <span class="font-normal font-black  span-center">أطيب التحيات</span>
        <span class="font-normal font-black  span-center"
            style="font-weight: 700; margin-bottom: 10px">{{ $setting->where('key', 'APP_NAME')->value('value') }}</span>
        <div class="footer">
            <h5 style="margin: 10px 0 ;color:#fff">تواصل معنا</h5>
            <span class="font-normal  span-center">{{ $setting->where('key', 'PHONE')->value('value') }}</span>
            <span class="font-normal span-center">{{ $setting->where('key', 'EMAIL')->value('value') }}</span>
            <div class="icon-div">
                <span class="icon-span">
                    <a target="_blank" href="{{ $setting->where('key', 'FACEBOOK')->value('value') }}">
                        <img src="{{ asset('public/' . Setting::UPLOADED_FILES . '/facebook%20(1).jpg') }}"
                            class="icon-logo" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="{{ $setting->where('key', 'X')->value('value') }}">
                        <img src="{{ asset('public/' . Setting::UPLOADED_FILES . '/xTwiter%20(1).png') }}"
                            class="icon-logo" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="{{ $setting->where('key', 'WHATSAPP')->value('value') }}">
                        <img src="{{ asset('public/' . Setting::UPLOADED_FILES . '/whatsapp%20(1).png') }}"
                            class="icon-logo" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="{{ $setting->where('key', 'YOUTUBE')->value('value') }}">
                        <img src="{{ asset('public/' . Setting::UPLOADED_FILES . '/yotube1.png') }}" class="icon-logo"
                            style="width: 30px" />
                    </a>
                </span>
                <span class="icon-span">
                    <a target="_blank" href="{{ $setting->where('key', 'INSTA')->value('value') }}">
                        <img src="{{ asset('public/' . Setting::UPLOADED_FILES . '/insta%20(1).jpeg') }}"
                            class="icon-logo"
                            style="  height: 25px;
                        width: 25px;
                        border-radius: 50%;" />
                    </a>
                </span>
            </div>
        </div>
        <div class="header" style="padding: 10px 0; font-size: 10px">
            جميع الحقوق محفوظة © {{ $setting->where('key', 'APP_NAME')->value('value') }}
        </div>
    </div>
</body>

</html>
