<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Email Verification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            /* color: #ffffff !important; */
        }

        .container {
            /* color: #ffffff !important; */

            display: flex;
            align-items: center;
            flex-direction: column;
            max-width: 600px;
            margin: 50px auto;
            /* padding: 20px; */
            /* background-color: hsl(210deg 27.5% 15.69%); */
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }

        p {
            color: #666666;
        }

        .verification-code {
            padding: 10px;
            /* background-color: #181717; */
            border-radius: 5px;
            font-size: 22px;
            font-weight: bold;
            color: #000000;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }

        .button:hover {
            background-color: #0056b3;
        }

        .logo {
            margin: 10px 0;
            height: 100px;
            border-radius: 30px;
        }

        .text1 {
            margin: 0 auto;
            color: #000000;

            padding: 5px 100px;
        }

        .text {
            margin: 0 auto;
            color: #000000;
            padding: 10px 100px;
        }

        .header {
            background-color: #1d6bb6;
            color: rgb(255, 255, 255);
            width: 100% !important;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .footer {
            height: 120px !important;
            width: 100%;
            background-color: #6797c5;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .icon-span {
            padding-top: 2px;
            height: 20px;
            width: 20px;
            border-radius: 50%;
            background-color: #fff;
            display: flex;
            justify-content: center;

            align-items: center;
        }

        .icon-div {
            display: flex;
            gap: 1rem;
            padding: 10px 0;
        }

        .font-normal {
            font-size: 12px;
        }
    </style>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
</head>

<body>
    <div class="container">
        <div class="header">
            <img src="./IMG-20240513-WA0000.jpg" class="logo" />

            <span style="margin-top: 20px">THANKS FOR SIGNING UP !</span>
            <h2>Email Verification</h2>
        </div>
        <p class="">Dear User,</p>
        <p class="text1">
            Thank you for signing up. Please use the following verification code to
            activate your account:
        </p>
        <div class="verification-code">ABC123</div>
        <p class="text">
            If you didn't request this verification code, you can safely ignore this
            email.
        </p>
        <span class="font-normal">Best regards,</span>
        <span class="font-normal" style="font-weight: 700; margin-bottom: 10px">System Ahlanuof Team</span>
        <div class="footer">
            <h5 style="margin: 10px 0">Get in touch</h5>
            <span class="font-normal">+11 111 333 4444</span>
            <span class="font-normal">Info@YourCompany.com</span>
            <div class="icon-div">
                <span class="icon-span">
                    <a href="#">
                        <i class="fa fa-facebook" style="color: #0056b3"></i>
                    </a>
                </span>
                <span class="icon-span">
                    <a href="#">
                        <i class="fa fa-twitter" style="color: #2a7fee"> </i>
                    </a>
                </span>
                <span class="icon-span">
                    <a href="#">
                        <i class="fa fa-whatsapp" style="color: #58f77a"> </i>
                    </a>
                </span>
                <span class="icon-span">
                    <a href="#">
                        <i class="fa fa-instagram" style="color: #ca1c33"> </i>
                    </a>
                </span>
            </div>
        </div>
        <div class="header" style="padding: 10px 0; font-size: 10px">
            Copyrights © Company All Rights Reserved
        </div>
    </div>
</body>

</html>
