<?php

use App\Http\Controllers\Api\Admin\MetaController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Admin\Unit\UnitController;
use App\Http\Controllers\Api\Company\CompanyController;
use App\Http\Controllers\Api\Package\FeatureController;
use App\Http\Controllers\Api\Admin\Admin\AdminController;
use App\Http\Controllers\Api\Admin\Auth\AdminAuthController;
use App\Http\Controllers\Api\Admin\Package\PackageController;
use App\Http\Controllers\Api\Admin\Setting\SettingController;
use App\Http\Controllers\Api\Admin\Auth\AdminProfileController;
use App\Http\Controllers\Api\Admin\Currency\CurrencyController;
use App\Http\Controllers\Api\Admin\Feature\FeatureController as FeatureFeatureController;
use App\Http\Controllers\Api\Admin\Location\LocationController;
use App\Http\Controllers\Api\Admin\StepController;
use App\Http\Controllers\CatogryUnitController;
Route::post('/login', [AdminAuthController::class, 'login']);


Route::post('/logout', [AdminAuthController::class, 'logout']);

Route::group([
    'controller' => AdminProfileController::class,
    'prefix' => 'profile'
], function () {
    Route::get('/', 'show');
    Route::put('/', 'update');
    Route::patch('/change-password', 'changePassword');
});
   Route::get('/unit-category', [CatogryUnitController::class, 'index']);
Route::group([
    'middleware' => 'auth:admin'
], function () {
    Route::apiResource('/admins', AdminController::class);

    Route::put('/packages', [PackageController::class, 'changeStatus']);
    Route::get('/features', [FeatureController::class, 'index']);
    Route::put('/features/{feature}', [FeatureController::class, 'update']);

    Route::get('/settings', [SettingController::class, 'index']);
    Route::put('/settings/{setting}', [SettingController::class, 'update']);

    Route::apiResource('/packages', PackageController::class);
    Route::apiResource('/locations', LocationController::class);
    Route::put('/companies/update-package', [CompanyController::class, 'updateCompanyPackage']);
    Route::post('/companies/send-mail', [CompanyController::class, 'sendMail']);
    Route::put('/companies/password/{company}', [CompanyController::class, 'updatePassword']);
    Route::apiResource('/companies', CompanyController::class);
    Route::apiResource('/main-units', UnitController::class);
    Route::apiResource('/main-currencies', CurrencyController::class);
    Route::apiResource('/advantages', FeatureFeatureController::class)->withoutMiddleware('lang');;

    Route::get('/steps', [StepController::class, 'index']);
    Route::put('/steps', [StepController::class, 'update']);

    // to get all meta tags for clients and companies

    Route::apiResource('/metas', MetaController::class);
});


