<?php

use App\Http\Controllers\Api\Company\Journal\JournalRepeationController;
use App\Http\Controllers\CompanySettingsController;
use App\Http\Controllers\InventoryController;
use App\Models\CompanySystemSetting;
use App\Models\Feature;
use Illuminate\Support\Facades\Route;
use App\Http\Enums\Order\OrderStatusEnum;
use App\Http\Controllers\Api\Bill\BillController;
use App\Http\Controllers\Api\ChangeLangController;
use App\Http\Controllers\Api\Bound\BoundController;
use App\Http\Controllers\Online\V1\OrderController;
use App\Http\Controllers\Api\Account\LevelController;
use App\Http\Controllers\Api\Company\Tax\TaxController;
use App\Http\Controllers\Api\Product\ProductController;
use App\Http\Controllers\Api\Service\ServiceController;
use App\Http\Controllers\CompanyMainSettingsController;
use App\Http\Controllers\Api\Company\Role\RoleController;
use App\Http\Controllers\Api\Company\SellNatureController;
use App\Http\Controllers\Api\Account\AccountModelController;
use App\Http\Controllers\Api\Company\Worker\WorkerController;
use App\Http\Controllers\Api\Company\Expense\ExpenseController;
use App\Http\Controllers\Api\Company\Journal\JournalController;
use App\Http\Controllers\Api\Company\Role\PermissionController;
use App\Http\Controllers\Api\Company\Unit\CompanyUnitController;
use App\Http\Controllers\Api\Company\Company\SubscribeController;
use App\Http\Controllers\Api\Branch\Warehouse\OpenBalanceController;
use App\Http\Controllers\Api\Company\AutoShiftController;
use App\Http\Controllers\Api\Company\Company\CompanySecretKeyController;
use App\Http\Controllers\Api\Company\Currency\CompanyCurrencyController;
use App\Http\Controllers\Api\Company\Excel\ExportController;
use App\Http\Controllers\Api\Company\Excel\ImportController;
use App\Http\Controllers\Api\Company\TreasuryBankNetwork\BankController;
use App\Http\Controllers\Api\Company\PaymentMethod\PaymentMethodController;
use App\Http\Controllers\Api\Company\TreasuryBankNetwork\NetworkController;
use App\Http\Controllers\Api\Company\Purchase\PurchaseRequirementController;
use App\Http\Controllers\Api\Company\Revenuse\RevenuesController;
use App\Http\Controllers\Api\Company\ShiftController;
use App\Http\Controllers\Api\Company\Step\StepController;
use App\Http\Controllers\Api\Company\TreasuryBankNetwork\TreasuryController;
use App\Http\Controllers\Api\Employee\Custody\CustodyController;
use App\Http\Controllers\Api\Employee\Custody\CustodyTakenController;
use App\Http\Controllers\Api\Shipments\ShipmentItemTypeController;
// use App\Http\Controllers\Api\Shipments\DiscountController;
use App\Http\Controllers\Api\Shipments\GetShipmentByStatusController;
use App\Http\Controllers\Api\Shipments\ShipmentController;
use App\Http\Controllers\Api\Shipments\ShipmentReceiverController;
use App\Http\Controllers\Api\Shipments\ShipmentStatusController;
use App\Http\Controllers\Api\Shipments\ShipmentTypeController;
use App\Http\Controllers\ReportController;

Route::post('/change-lang', ChangeLangController::class);

Route::group(
    [
        'prefix' => 'subscriptions',
        'controller' => SubscribeController::class,
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'subscribe');
    }
);

Route::patch('/next-step', [StepController::class, 'next']);
Route::patch('/previous-step', [StepController::class, 'previous']);

Route::group(
    [
        'prefix' => 'secret-key',
        'controller' => CompanySecretKeyController::class,
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
    }
);

Route::get('/account-levels', [LevelController::class, 'index']);
Route::apiResource('/expenses', ExpenseController::class);
Route::apiResource('/shifts', ShiftController::class)->except(['destroy']);
Route::apiResource('/auto-shifts', AutoShiftController::class);

Route::group(
    [
        'prefix' => 'bills',
        'controller' => BillController::class,
    ],
    function () {
        Route::get('/{type}/{billType}/', 'index')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
        Route::get('/{type}/{billType}/{bill}', 'show')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
        Route::post('/{type}/{billType}', 'store')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
        Route::put('/{type}/{billType}/{bill}', 'update')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
        Route::delete('/{type}/{billType}/{bill}', 'destroy')->where('type', 'sales|purchases')->where('billType', 'invoice|order');
        // invoice for fast sales
        Route::get('/fast-sales', 'getFastSalesInvoices');
        Route::get('/orders/{id}', 'getOrders');
    }
);

Route::group(
    [
        'prefix' => 'main-settings',
        'controller' => CompanyMainSettingsController::class
    ],
    function () {
        Route::get('/', 'index');
        Route::patch('/{companyMainSettings}', 'update')->middleware('company-main-setting');
    }
);

Route::group(
    [
        'prefix' => 'open-balances',
        'controller' => OpenBalanceController::class
    ],
    function () {
        Route::get('/', 'index');
         Route::get('/{openBalance}', 'show');
        Route::post('/', 'store');
        Route::put('/{openBalance}', 'update');
    }
);
Route::group(
    [
        'prefix' => 'system-settings',
        'controller' => CompanySettingsController::class
    ],
    function () {
        Route::get('/', 'index');
        Route::put('/{companySystemSetting}', 'updateSettings');
    }
);

Route::group(
    [
        'prefix' => 'journals',
        'controller' => JournalController::class,
        'middleware' =>
            [
                'company-has-feature:' . Feature::FEATURE_JOURNAL_ENTRIES,
            ],
    ],
    function () {
        Route::get('/reports', 'reports');
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::delete('/{journal}', 'destroy');
        Route::put('/{journal}', 'update');
        Route::get('/{journal}', 'show');
        
        // Route::get('/{journal}/files', 'getFiles'); 
        // Route::post('/{journal}/files', 'uploadFile');
        // Route::delete('/{journal}/files/{file}', 'deleteFile');
        Route::get('/{journal}/files', 'getFiles'); 
        Route::post('/{journal}/files', 'uploadJournalFile');
        Route::delete('/{journal}/files/{file}', 'deleteJournalFile');
    }
);


Route::patch('online/orders/{order}/status/{status}', [OrderController::class, 'updateStatus'])->where('status', implode('|', OrderStatusEnum::getOrderStatuses()));
Route::apiResource('online/orders', OrderController::class)->except(['update']);

Route::group(
    [
        'prefix' => 'bounds/{type}',
        'controller' => BoundController::class,
        'middleware' =>
            [
                'company-has-feature:' . Feature::FEATURE_PAYMENTS_AND_RECEIVABLES,
            ],
    ],
    function () {
        Route::post('/archive', 'toggleArchive')->where('type', 'payments|receivables');
        Route::get('/archive', 'archived')->where('type', 'payments|receivables');
        
        Route::get('/', 'index')->where('type', 'payments|receivables');
        Route::post('/', 'store')->where('type', 'payments|receivables');
        Route::put('/{bound}', 'update')->where('type', 'payments|receivables');
        Route::get('/{bound}', 'show')->where('type', 'payments|receivables');
        Route::delete('/{bound}', 'destroy')->where('type', 'payments|receivables');

    }
);

Route::group(
    [
        'prefix' => 'accounts-companies-models',
        'controller' => AccountModelController::class,
        'middleware' =>
            [
                'company-has-feature:' . Feature::FEATURE_ACCOUNTS_SETTINGS,
            ],
    ],
    function () {
        Route::get('/', 'index');
        // Route::post('/accounts/{account}/models/{model}', 'store');
          Route::post('/accounts/{account}/models/{model}/groups/{group}', 'store');
        Route::delete('/accounts/{account}/models/{model}', 'destroy');
    }
);

Route::group(
    [
        'prefix' => 'units',
        'controller' => CompanyUnitController::class,
        'middleware' =>
            [
                'company-unit'
            ]
    ],
    function () {
        Route::get('/', 'index')->withoutMiddleware('company-unit');
        Route::post('/', 'store')->withoutMiddleware('company-unit');
        Route::put('/{companyUnit}', 'update');
        Route::delete('/{companyUnit}', 'destroy');
    }
);

Route::group(
    [
        'prefix' => 'currencies',
        'controller' => CompanyCurrencyController::class,
        'middleware' =>
            [
                'company-currency'
            ]
    ],
    function () {
        Route::get('/', 'index')->withoutMiddleware('company-currency');
        Route::post('/', 'store')->withoutMiddleware('company-currency');
        Route::put('/{companyCurrency}', 'update');
        Route::delete('/{companyCurrency}', 'destroy');
    }
);


Route::group(
    [
        'prefix' => 'products',
        'controller' => ProductController::class,
        'middleware' =>
            [
                'company-product',
                'company-has-feature:' . Feature::FEATURE_PRODUCTS,
            ],
    ],
    function () {
        Route::get('/', 'index')->withoutMiddleware('company-product');
        Route::post('/', 'store')->withoutMiddleware('company-product');
        Route::get('/generate-key', 'generateUniqueKey')->withoutMiddleware('company-product');
        Route::get('/{product}', 'show');
        Route::put('/{product}', 'update');
        Route::patch('/{product}', 'changeStatus');
        Route::delete('/{product}', 'destroy');
        Route::delete('/checked-products/delete', 'deleteAll')->withoutMiddleware('company-product');
    }
);

Route::group(
    [
        'prefix' => 'services',
        'controller' => ServiceController::class,
        'middleware' =>
            [
                'company-has-feature:' . Feature::FEATURE_SERVICES,
            ],
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::get('/{service}', 'show');
        Route::put('/{service}', 'update');
        Route::delete('/{service}', 'destroy');
    }
);

Route::get('/permissions', [PermissionController::class, 'index']);
Route::group(
    [
        'controller' => RoleController::class,
        'prefix' => 'roles',
        'middleware' =>
            [
                'company-has-feature:' . Feature::FEATURE_WORKERS,
            ],
    ],
    function () {
        Route::get('/', 'index');
        Route::get('/{role}', 'show');
        Route::delete('/{role}', 'destroy');
        Route::post('/{role}/attach-permissions', 'attachPermissions');
        Route::post('/{worker}/attach-worker-permissions', 'attachWorkerPermission');
        Route::post('/', 'store');
    }
);

Route::group(
    [
        'controller' => WorkerController::class,
        'prefix' => 'workers',
        'middleware' =>
            [
                'company-has-feature:' . Feature::FEATURE_WORKERS,
            ],
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::get('/{worker}', 'show');
        Route::put('/{worker}', 'update');
        Route::delete('/{worker}', 'destroy');
    }
);

Route::group(
    [
        'controller' => TaxController::class,
        'prefix' => 'taxes',
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::get('/{tax}', 'show');
        Route::put('/{tax}', 'update');
        Route::delete('/{tax}', 'destroy');
    }
);

// Route::group(
// [
//     'controller' => PaymentTermController::class,
//     'prefix' => 'payment-terms',
// ], function () {
//     Route::get('/', 'index');
//     Route::post('/', 'store');
//     Route::get('/{paymentTerm}', 'show');
//     Route::put('/{paymentTerm}', 'update');
//     Route::delete('/{paymentTerm}', 'destroy');
// });

// Route::group(
// [
//     'controller' => ShipmentCompanyController::class,
//     'prefix' => 'shipment-companies',
// ], function () {
//     Route::get('/', 'index');
//     Route::post('/', 'store');
//     Route::get('/{shipmentCompany}', 'show');
//     Route::put('/{shipmentCompany}', 'update');
//     Route::delete('/{shipmentCompany}', 'destroy');
// });

Route::group(
    [
        'controller' => PaymentMethodController::class,
        'prefix' => 'payment-methods',
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
    }
);

Route::group(
    [
        'controller' => TreasuryController::class,
        'prefix' => 'treasuries',
        'as' => 'treasuries',
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::get('/{treasury}', 'show');
        Route::put('/{treasury}', 'update');
        Route::delete('/{treasury}', 'destroy');
    }
);

Route::group(
    [
        'controller' => BankController::class,
        'prefix' => 'banks',
        'as' => 'banks',
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::get('/{bank}', 'show');
        Route::put('/{bank}', 'update');
        Route::delete('/{bank}', 'destroy');
    }
);

Route::group(
    [
        'controller' => NetworkController::class,
        'prefix' => 'networks',
        'as' => 'networks',
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::get('/{network}', 'show');
        Route::put('/{network}', 'update');
        Route::delete('/{network}', 'destroy');
    }
);

Route::group(
    [
        'controller' => SellNatureController::class,
        'prefix' => 'selling-natures',
    ],
    function () {
        Route::get('/', 'index');
        Route::post('/', 'store');
        Route::put('/{mainSellNature}', 'update');
    }
);

Route::get('/purchases-requirements', [PurchaseRequirementController::class, 'index']);


Route::apiResource('custodies', CustodyController::class);


Route::group(
    [
        'controller' => CustodyTakenController::class,
        'prefix' => 'custodies-taken',
    ],
    function () {
        Route::get('/', 'index');
        Route::get('/{custodyTaken}', 'show');
        Route::post('/', 'store');
    }
);

Route::get('income-list-report', [ReportController::class, 'getIncomeListReport']);
Route::get('finical-center-report', [ReportController::class, 'getFinancialCenterReport']);

//Imports
Route::post('import-clients', [ImportController::class, 'importClients']);
Route::post('import-suppliers', [ImportController::class, 'importSuppliers']);
// Route::post('import-products', [ImportController::class, 'importProducts'])->withoutMiddleware(['api', 'auth:company,worker', 'lang']);
Route::post('import-products', [ImportController::class, 'importProducts']);
Route::post('import-services', [ImportController::class, 'importServices']);
Route::post('import-regions', [ImportController::class, 'importRegions']);

//Exports
// Route::get('export-products', [ExportController::class, 'getProductsSheet'])->withoutMiddleware(['api', 'auth:company,worker', 'lang']);
Route::get('export-products', [ExportController::class, 'getProductsSheet']);


Route::group([
    'controller' => RevenuesController::class,
    'prefix' => 'revenues',
], function () {
    Route::get('company', 'getCompanyRevenues');
    Route::get('merchant', 'getMerchantsRevenues');
    Route::post('company', 'storeCompanyRevenues')->middleware('CompanySecretKeyAuth')->withoutMiddleware('auth:company,worker');
    Route::post('merchant', 'storeMerchantRevenues')->middleware('CompanySecretKeyAuth')->withoutMiddleware('auth:company,worker');
});

Route::get('journal-repeations', [JournalRepeationController::class, 'index']);
Route::put('journal-repeations/{journalReptation}', [JournalRepeationController::class, 'update']);
Route::delete('journal-repeations/{journalReptation}', [JournalRepeationController::class, 'destroy']);
Route::get('journal-repeations/notifications', [JournalRepeationController::class, 'getNotifications']);
Route::post('journal-repeations/notifications', [JournalRepeationController::class, 'handleNotification']);
Route::apiResource('inventories', InventoryController::class);




Route::apiResource('shipments', ShipmentController::class);
Route::get('discounts', [DiscountController::class , 'index']);
Route::put('shipments/status/{id}', [ShipmentController::class , 'updateShipmentStatus']);
Route::put('shipments/accept/{id}', [ShipmentController::class , 'acceptShipmentFromClient']);
Route::put('shipments/assign/{id}', [ShipmentController::class , 'assignShipmentForDelivery']);
Route::apiResource('shipments-item-types', ShipmentItemTypeController::class);
Route::apiResource('shipments-types', ShipmentTypeController::class);
Route::apiResource('shipments-receivers', ShipmentReceiverController::class);


// update status of shippment
Route::group(
    [
        'controller' => ShipmentStatusController::class,
    ],
    function () {
        Route::put('/accept-shippment/{id}', 'acceptShipmentFromClient');
        Route::put('/assign-delivery/{id}', 'assignShipmentForDelivery');
        Route::put('/delivered-to-delivery/{id}', 'deliverShipmentForDelivery');
        Route::put('/processing-shippment/{id}', 'processingShipment');
        Route::put('/delivered-shippment/{id}', 'deliveredShipment');
        Route::put('/canceled-shippment/{id}', 'canceledShipment');
    }
);
// get  shippment by status
Route::group(
    [
        'controller' => GetShipmentByStatusController::class,
    ],
    function () {
        Route::get('/pending-shippment', 'getPendingShipment');
        Route::get('/accept-shippment', 'getAcceptedShipment');
        Route::get('/assigned-shipment', 'getAssigenedShipment');
        Route::get('/delivery-shipment', 'getDeliveryShipment');
        Route::get('/processing-shippment', 'getProcessingShipment');
        Route::get('/delivered-shippment', 'getDeliveredShipment');
        Route::get('/canceled-shippment', 'getCanceledShipment');
    }
);
