<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Employee\EmployeeController;
use App\Http\Controllers\Api\Employee\Career\CareerController;
use App\Http\Controllers\Api\Company\Absence\AbsenceController;
use App\Http\Controllers\Api\Employee\Section\SectionController;
use App\Http\Controllers\Api\Company\Vacation\VacationController;
use App\Http\Controllers\Api\Employee\Attendance\AttendanceMethodController;
use App\Http\Controllers\Api\Employee\Transaction\EmployeeTransactionController;
use App\Http\Controllers\Api\Company\PermissionRequest\PermissionRequestController;
use App\Http\Controllers\Api\Company\VacationRequest\VacationRequestController;

Route::group([
    'controller' => SectionController::class,
    'prefix' => 'sections',
    'middleware' => [
        'company-section'
    ],
], function () {
    Route::get('/', 'index')->withoutMiddleware(['company-section']);
    Route::post('/', 'store')->withoutMiddleware(['company-section']);
    Route::get('/{section}', 'show');
    Route::put('/{section}', 'update');
    Route::delete('/{section}', 'destroy');
});

Route::group([
    'controller' => AttendanceMethodController::class,
    'prefix' => 'attendance-methods',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{attendanceMethod}', 'show');
    Route::put('/{attendanceMethod}', 'update');
    Route::delete('/{attendanceMethod}', 'destroy');
});

Route::group([
    'controller' => CareerController::class,
    'prefix' => 'careers',
    'middleware' => [
        'company-career'
    ],
], function () {
    Route::get('/', 'index')->withoutMiddleware(['company-career']);
    Route::post('/', 'store')->withoutMiddleware(['company-career']);
    Route::get('/{career}', 'show');
    Route::put('/{career}', 'update');
    Route::delete('/{career}', 'destroy');
});

Route::group([
    'controller' => EmployeeTransactionController::class,
    'prefix' => 'employee-transactions',
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
});

Route::group([
    'prefix' => 'vacation-requests',
    'controller' => VacationRequestController::class,
    // 'middleware' => [
    //     'company-product'
    // ],
], function () {
    Route::get('/',  'index');
    Route::post('/', 'store');
    Route::get('/{vacationRequest}', 'show');
    Route::put('/change-vacation-request-status/{vacationRequest}',  'changeStatus');
    Route::put('/{vacationRequest}',  'update');
    Route::delete('/{vacationRequest}',  'destroy');
});

Route::group([
    'prefix' => 'vacations',
    'controller' => VacationController::class,
    // 'middleware' => [
    //     'company-product'
    // ],
], function () {
    Route::get('/',  'index');
    Route::post('/', 'store');
    Route::get('/{vacation}', 'show');
    Route::put('/{vacation}',  'update');
    Route::delete('/{vacation}',  'destroy');
});

Route::group([
    'prefix' => 'permissionRequests',
    'controller' => PermissionRequestController::class,
], function () {
    Route::get('/',  'index');
    Route::post('/', 'store');
    Route::get('/{permissionRequest}', 'show');
    Route::put('/{permissionRequest}',  'update');
    Route::delete('/{permissionRequest}',  'destroy');
});

Route::group([
    'prefix' => 'absences',
    'controller' => AbsenceController::class,
    // 'middleware' => [
    //     'company-product'
    // ],
], function () {
    Route::get('/',  'index');
    Route::post('/', 'store');
    Route::get('/{absence}', 'show');
    Route::put('/{absence}',  'update');
    Route::delete('/{absence}',  'destroy');
});

Route::group([
    'controller' => EmployeeController::class,
], function () {
    Route::get('/', 'index');
    Route::post('/', 'store');
    Route::get('/{employee}', 'show');
    Route::put('/{employee}', 'update');
    Route::delete('/{employee}', 'destroy');
});
