<?php

namespace App\Http\Controllers\Api\Account;

use App\Models\Account;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\AccountResource;
use App\Http\Services\Account\AccountService;
use App\Http\Requests\Api\Account\StoreAccountRequest;
use App\Http\Requests\Api\Account\SearchAccountRequest;
use App\Http\Requests\Api\Account\UpdateAccountRequest;

class AccountController extends Controller
{
    /**
     * => function ($query) use ($request) {
                                return  $query
                                    ->when(
                                        $request->has('from'),
                                        fn ($q) => $q->whereDate('created_at', '>=', $request->input('from'))
                                    )
                                    ->when(
                                        $request->has('to'),
                                        fn ($q) => $q->whereDate('created_at', '<=', $request->input('to'))
                                    );
                            }

                                                    // 'model',
                        // 'children' => function ($query) use ($request) {
                        //     if ($request->has('level')) {
                        //         return $query->where('level_id', $request->input('level'));
                        //     }
                        // },
                        // 'children.model',
     */
    use ApiTrait;

    public function index(Request $request)
    {
        return $this->apiResponse(
            // data: AccountResource::collection(
            Account::whereBelongsTo(CompanyHelper::getCompany(request()))
                ->with(
                    [
                        'entries',
                        'childrenWithEntries'
                    ]
                )
                ->whereNull('parent_id')
                ->get()
            // )
        );
    }

    public function show(Account $account)
    {
        $account->load([
            'children',
            'entries.journal',
            'entries.type',
        ]);

        return $this->apiResponse(data: AccountResource::make($account));
    }

    public function store(StoreAccountRequest $request, Account $account)
    {
        return $this->apiResponse(
            message: 'Account created successfully.',
            data: new AccountResource(
                CompanyHelper::getCompany(request())->accounts()->create([
                    'code' => AccountService::generateCode($account),
                    'level_id' => AccountService::$nextLevel->id
                ] + $request->validated())
            )
        );
    }

    public function update(UpdateAccountRequest $request, Account $account)
    {
        $account->update($request->validated());
        return $this->apiResponse(message: 'Account updated successfully.', data: new AccountResource($account));
    }

    public function destroy(Account $account)
    {
        AccountService::deleteAccount($account);
        return $this->apiResponse(message: 'Account deleted successfully.');
    }

    public function search(SearchAccountRequest $request)
    {
        $accounts = Account::where('company_id', auth()->id())
            ->codeSearch($request->code)
            ->get();
        $accounts = AccountResource::collection($accounts);
        return $this->apiResponse(data: $accounts);
    }
}
