<?php

namespace App\Http\Controllers\Api\Admin\Location;

use App\Trait\ApiTrait;
use App\Models\Location;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\LocationResource;
use App\Http\Requests\Api\Admin\Location\StoreLocationRequest;
use App\Http\Requests\Api\Admin\Location\UpdateLocationRequest;

class LocationController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        return $this->apiResponse(
            data: LocationResource::collection(
                Location::when(
                    $request->has('location'),
                    fn ($q) => $q->where('id', $request->location)->with(['children']),
                    fn ($q) => $q->whereNull('parent_id'),
                )->get()
            )
        );
    }

    public function store(StoreLocationRequest $request)
    {
        Location::create($request->validated());
        return $this->apiResponse(message: "Location created successfully.");
    }

    public function show(Location $location)
    {
        $location->load(['children']);
        return $this->apiResponse(data: LocationResource::make($location));
    }

    public function update(UpdateLocationRequest $request, Location $location)
    {
        $location->update($request->validated());
        return $this->apiResponse(message: "Location Updated successfully.");
    }

    public function destroy(Location $location)
    {
        $location->delete();
        return $this->apiResponse(message: "Location deleted successfully.");
    }
}
