<?php

namespace App\Http\Controllers\Api\BlockReason;

use App\Trait\ApiTrait;
use App\Models\BlockReason;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\BlockReasonResouce;
use App\Http\Resources\BlockReasonResource;
use App\Http\Requests\Api\Client\BlockReason\StoreBlockReasonRequest;
use App\Http\Requests\Api\Client\BlockReason\UpdateBlockReasonRequest;

class BlockReasonController extends Controller
{
    use ApiTrait;

    public function index()
    {


        return $this->apiResponse(data: BlockReasonResource::collection(BlockReason::where('company_id', CompanyHelper::getId())->get()));
    }

    public function store(StoreBlockReasonRequest $request)
    {
        $reason = BlockReason::create([
            'company_id' => auth()->id(),
            'option_label' => BlockReason::KEY,
            'dropdown_name' => $request->dropdown_name,
            'option_value' => $request->dropdown_name,
        ]);
        $reason = new BlockReasonResource($reason);
        return $this->apiResponse(data: $reason, message: 'Reason created successfully.');
    }

    public function update(UpdateBlockReasonRequest $request, BlockReason $reason)
    {
        $reason->update($request->validated());
        $reason = new BlockReasonResource($reason);
        return $this->apiResponse(data: $reason, message: 'Block Reason updated successfully.');
    }

    public function destroy(BlockReason $reason)
    {
        $reason->delete();
        return $this->apiResponse(message: 'Block Reason deleted successfully.');
    }
}
